//2.RADIATION PATTERN  OF CONCENTRIC CIRCULAR ARRAY ANTENNA (RECTANGULAR PLOT) 
//OS-Windows 7
//Scilab 6.0.2
// RADIATION PATTERN MEASUREMENT OF ANTENNA ARRAYS
//Course Instructor Name: Dr. V. A. Sankar Ponnapalli
//Institute Name: Sreyas Institute of Engineering & Technology
clc;
clear;
close;
//r=input('radius=');// IN WAVELENGHTS
N=input('NUMBER OF ANTENNA ELEMENTS=')
M=input('NUMBER OF CONCENTRIC RINGS=')
r=[0.5,1,1.5]; // Radius
af=0; // af-Array Factor
thio=0; //STEERING ANGLE
phio=0; // STEERING ANGLE
phi=%pi/2; // Elevation Angle
thi=-%pi:%pi/10000:%pi; // Azimuthal Angle
k=2*%pi // Wave Number
for m=1:M// NUMBER OF CONCENTRIC RINGS
    for n=1:N // NUMBER OF ANTENNA ELEMENTS
        phimn=(n-1).*(2.*%pi/N) // Antenna Element Position
        a=(exp(%i.*k.*r(m).*(((sin(thi)*cos(phi-phimn)))-(sin(thio)*cos(phio-phimn)))));
        af=a+af;
    end
end 
af1=abs(af);// af1- Array Factor
af1=af1/max(max((af1)));
CCAA=20.*log10(af1); // CCAA-CONCENTRIC CIRCULAR ARRAY ANTENNA
plot((thi*57.3),(CCAA));
xlabel('THETA');
ylabel('ARRAY FACTOR (dB)');
title('RADIATION PATTERN OF CIRCULAR ARRAY ANTENNA');
h=gca();
h.data_bounds=[-90,-80;90,0];

// INPUT PARAMETERS 

//NUMBER OF ANTENNA ELEMENTS=10

//NUMBER OF CONCENTRIC RINGS=3

// DESCRIPTION OF THE FIGURE: 
//*************************ARRAY FACTOR PROPERTIES***************************
//                            Half Power Beam Width (HPBW): 19.2 (In degrees) 
//                            Side Lobe Level (SLL)       : -28.8 dB
//                            Side Lobe Level Angle (SLLA): 31.9 (In degrees) 


